/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.party.io;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import xaero.pac.OpenPartiesAndClaims;
import xaero.pac.common.parties.party.ally.PartyAlly;
import xaero.pac.common.server.config.ServerConfig;
import xaero.pac.common.server.io.FileIOHelper;
import xaero.pac.common.server.io.FilePathConfig;
import xaero.pac.common.server.io.IOThreadWorker;
import xaero.pac.common.server.io.ObjectManagerIO;
import xaero.pac.common.server.io.serialization.SerializationHandler;
import xaero.pac.common.server.io.serialization.SerializedDataFileIO;
import xaero.pac.common.server.parties.party.PartyManager;
import xaero.pac.common.server.parties.party.ServerParty;

public final class PartyManagerIO<S>
extends ObjectManagerIO<S, String, ServerParty, PartyManager> {
    private final Path partiesPath;
    private final boolean partiesEnabled;

    private PartyManagerIO(String extension, SerializationHandler<S, String, ServerParty, PartyManager> serializationHandler, SerializedDataFileIO<S, String> serializedDataFileIO, IOThreadWorker ioThreadWorker, MinecraftServer server, PartyManager manager, FileIOHelper fileIOHelper) {
        super(serializationHandler, serializedDataFileIO, ioThreadWorker, server, extension, manager, fileIOHelper);
        this.partiesPath = server.method_27050(class_5218.field_24188).resolve("data").resolve("openpartiesandclaims").resolve("parties");
        this.partiesEnabled = (Boolean)ServerConfig.CONFIG.partiesEnabled.get();
    }

    @Override
    protected Stream<FilePathConfig> getObjectFolderPaths() {
        return Stream.of(new FilePathConfig(this.partiesPath, false));
    }

    @Override
    public void load() {
        if (!this.partiesEnabled) {
            return;
        }
        OpenPartiesAndClaims.LOGGER.info("Loading parties...");
        super.load();
        ((PartyManager)this.manager).getTypedAllStream().forEach(p -> {
            Iterator<PartyAlly> allyPartyIterator = p.getAllyPartiesIterator();
            ArrayList<UUID> alliesToRemove = null;
            while (allyPartyIterator.hasNext()) {
                UUID allyId = allyPartyIterator.next().getPartyId();
                ServerParty allyParty = ((PartyManager)this.manager).getPartyById(allyId);
                if (allyParty == null) {
                    if (alliesToRemove == null) {
                        alliesToRemove = new ArrayList<UUID>();
                    }
                    alliesToRemove.add(allyId);
                    continue;
                }
                p.updateAllyNameMap(allyParty.getId(), allyParty.getOwner().getUsername());
            }
            if (alliesToRemove != null) {
                alliesToRemove.forEach(p::removeAllyParty);
            }
        });
        ((PartyManager)this.manager).setLoaded(true);
        OpenPartiesAndClaims.LOGGER.info("Loaded parties!");
    }

    @Override
    public boolean save() {
        if (!this.partiesEnabled) {
            return true;
        }
        OpenPartiesAndClaims.LOGGER.debug("Saving parties...");
        return super.save();
    }

    @Override
    protected Path getFilePath(ServerParty object, String fileName) {
        return this.partiesPath.resolve(fileName + this.fileExtension);
    }

    @Override
    public void delete(ServerParty object) {
        if (!this.partiesEnabled) {
            return;
        }
        super.delete(object);
    }

    @Override
    public void onServerTick() {
        super.onServerTick();
    }

    @Override
    protected String getObjectId(String fileNameNoExtension, Path file, FilePathConfig filePathConfig) {
        return fileNameNoExtension;
    }

    @Override
    protected void onObjectLoad(ServerParty loadedObject) {
        ((PartyManager)this.manager).addParty(loadedObject);
    }

    public static final class Builder<S>
    extends ObjectManagerIO.Builder<S, String, ServerParty, PartyManager, Builder<S>> {
        private Builder() {
        }

        @Override
        public Builder<S> setDefault() {
            super.setDefault();
            return this;
        }

        protected PartyManagerIO<S> buildInternally() {
            return new PartyManagerIO(this.fileExtension, this.serializationHandler, this.serializedDataFileIO, this.ioThreadWorker, this.server, (PartyManager)this.manager, this.fileIOHelper);
        }

        public PartyManagerIO<S> build() {
            return (PartyManagerIO)super.build();
        }

        public static <S> Builder<S> begin() {
            return new Builder<S>().setDefault();
        }
    }
}

